import { IconType } from "@/types/utils";
import React from "react";

const StarSmileIcon: IconType = ({ size, ...props }) => (
  <svg
    width={size || "16"}
    height={size || "16"}
    viewBox="0 0 16 16"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <g clipPath="url(#clip0_1_12182)">
      <path
        d="M8.00002 0.333359L10.8174 4.45536L15.6087 5.86136L12.5587 9.81469L12.702 14.8054L8.00002 13.1267L3.29802 14.8054L3.44136 9.81469L0.391357 5.86136L5.18269 4.45536L8.00002 0.333359ZM6.66669 8.00002H5.33336C5.33335 8.69573 5.60522 9.36389 6.09096 9.86194C6.5767 10.36 7.23785 10.6485 7.93334 10.6659C8.62882 10.6833 9.30357 10.4282 9.81361 9.95507C10.3236 9.48192 10.6286 8.82819 10.6634 8.13336L10.6667 8.00002H9.33336C9.33491 8.34601 9.2019 8.67906 8.96244 8.92879C8.72298 9.17853 8.39581 9.3254 8.05007 9.33839C7.70432 9.35137 7.36706 9.22944 7.10955 8.99836C6.85203 8.76729 6.69443 8.44516 6.67002 8.10002L6.66669 8.00002Z"
        fill="currentColor"
      />
    </g>
    <defs>
      <clipPath id="clip0_1_12182">
        <rect width="16" height="16" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export default StarSmileIcon;
